import pytest
from discount import calculate_discount_percent

"""
Prac 4, Part 1: Unit testing

For this part, you'll write tests to check the correctness of an existing
function, rather than writing a function to pass existing tests as you usually
do.

There are four tasks; 0-2 are done in this file, while 3 is done in discount.py.
0. Equivalence partitioning - divide the input space into partitions where
   the function should behave the same.
1. Test the partitions - write test cases for values in the "middle" of each
   partition.
2. Boundary value analysis - write test cases to ensure that the code is correct
   on either side of the boundaries between partitions.
3. Debug the function under test using the test results.

Here's the function header and spec for the function under test, for reference:

def calculate_discount_percent(amount):
    Calculate a bulk discount percentage (as a fraction between 0 and 1)
    based on the purchase amount. Precondition: amount is a float. 
    Requirements:
    1. If the amount is negative, the string "Purchase amount cannot be negative." is returned
    2. If amount is less than 100.00, the discount is 0%.
    3. If amount is between 100.00 (inclusive) and 500.00 (exclusive), the discount is 5%.
    4. If amount is 500.00 or more (inclusive), the discount is 10%.

================================
Part 1 Task 0: Equivalence Partitioning
================================

Identify exactly four ranges of inputs where the function should behave equivalently.
1. Less than zero
2. (fill the rest in yourself)
3. 
4. 

We'll call these partitions, since they partition the space of possible inputs.

===========================
Part 1 Task 1: Test each partition
===========================
Below, we will write a separate test function for each test case. In practice,
we'd often combine mutliple assert statements into a single function but here
we will keep them separate for maximum granularity.

Your goal in task 1 is to create one test case for a value somewhere "in the
middle" of each of the four partitions you identified above. The first one
(less than zero) is done for you.

After implementing the remaining three test cases correctly, you should be able
to run this test program and see two tests failing (1_3 and 2_2) and the rest
passing.

Tempting though it may be, don't go debug the function yet - we still have more
testing to do!

"""

def test_1_1():
    """ Partition 1: invalid (negative) input - returns an error string """
    assert calculate_discount_percent(-50.00) == "Purchase amount cannot be negative."
    
def test_1_2():
    """ Partition 2: TODO """
    # assert calculate_discount_percent(...) == ...
    
def test_1_3():
    """ Partition 3: TODO """
    # assert calculate_discount_percent(...) == ...
    
def test_1_4():
    """ Partition 4: TODO """
    # assert calculate_discount_percent(...) == ...
    
"""
===============================
Part 1 Task 2: Boundary Value Analysis
===============================

In Task 0, you identified four partitions of the input space. We could
draw them like this:
(partition 1) | (partition 2) | (partition 3) | (partition 4)
             (1)             (2)             (3)
             
Our goal in Task 2 is to test values at the boundaries between partitions,
drawn with | characters and labeled (1)-(3) in the above diagram. In
particular, we want to make sure that the function behaves correctly just to
either side of each boundary. There are 3 boundaries in our diagram, so we
will write 6 test cases for this task. The tests around the first boundary
(between negative and nonnegative values) have been written for you.

After implementing the remaining six test cases correctly, you should be able
to run this test program and see five tests failing (1_3 and 2_2 from before,
and now 2_4, 2_5, and 2_6 from the ones you just wrote) while the other five
should be passing.
"""

def test_2_1():
    """ Boundary 1 - left side: Just below 0 (invalid) """

def test_2_2():   
    """ Boundary 1 - right side: exactly 0 """
    
def test_2_3():    
    """ Boundary 2 - left side: TODO """
    # assert ...

def test_2_4():    
    """ Boundary 2 - right side: TODO """
    # assert ...

def test_2_5():    
    """ Boundary 3 - left side: TODO """
    # assert ...

def test_2_6():    
    """ Boundary 3 - right side: TODO """
    # assert ...

"""
=================
Part 1 Task 3: Debugging
=================
Now that we have a fairly comprehensive test suite, we can debug our program.
If we can get it to pass all the tests, we can be pretty sure it's correct!

Open discount.py and fix the errors that are causing the five failing tests.
"""
if __name__ == '__main__':
    pytest.main(["discount_test.py", "-vv", "-p", "no:faulthandler"])