# Prac 3 Part 2 Tests (2 of 20 points)
import pytest

import prac3_part2

# Test cases: ((a, b, c, d, f), expected_lines)
test_cases = [
    ((3, 5, 6, 4, 1),
     ['    #', '  # #', '  # # #', '# # # #', '# # # #', '# # # # #', 'a b c d f']),
    ((0, 1, 0, 0, 0),
     ['  #', 'a b c d f']),
    ((1, 2, 3, 5, 0),
     ['      #', '      #', '    # #', '  # # #', '# # # #', 'a b c d f']),
    ((0, 0, 0, 0, 0),
     ['a b c d f'])
]

@pytest.mark.parametrize("inputs, expected", test_cases)
@pytest.mark.timeout(3)
def test_plot(inputs, expected):
    result = prac3_part2.plot_dist(*inputs)
    output_lines = [line.rstrip() for line in result.rstrip().split('\n')]
    
    assert output_lines == expected
    

if __name__ == "__main__":
    pytest.main(["prac3_part2_test.py", "-vv",  "-p", "no:faulthandler"])
