# Prac 3 Part 1C Tests (4 of 20 points)
import sys
import subprocess
import pytest

import prac3_part1


main_cases = [
    ((2023, 1, 1), 1),
    ((2023, 2, 1), 32),
    ((2024, 3, 1), 61),
    ((2024, 2, 28), 59),
]

def test_mainguard(capsys):
    command = [sys.executable, "-c", "import prac3_part1"]
    message = "importing prac3_part1 should not print any output or cause an error; make sure your main program is in a main guard"
    try:
        assert subprocess.check_output(command, text=True) == "", message
    except subprocess.CalledProcessError:
        assert False, message

@pytest.mark.parametrize("inputs, expected", main_cases)
def test_mainprogram(inputs, expected):
    command = [sys.executable, "prac3_part1.py", *[str(x) for x in inputs]]
    output = subprocess.check_output(command, text=True).rstrip()
    
    assert output == str(expected)

if __name__ == "__main__":
    pytest.main(["prac3_part1C_test.py", "-v",  "-p", "no:faulthandler"])
    
    
