# Prac 3 Part 1A Tests (8 of 20 points)
import pytest

import prac3_part1

# Test cases for days_in_month: ((year, month), days)
days_in_month_cases = [
    # non-leap years
    ((2023, 1), 31),    # January
    ((2021, 2), 28),    # February (non-leap)
    ((2022, 2), 28),    # February (non-leap)
    ((2025, 2), 28),    # February (non-leap)
    ((2022, 3), 31),    # March
    ((2025, 4), 30),    # April
    ((1901, 5), 31),    # May
    ((2023, 6), 30),    # June
    ((2023, 7), 31),    # July
    ((2023, 8), 31),    # August
    ((2023, 9), 30),    # September
    ((2023, 10), 31),   # October
    ((2023, 11), 30),   # November
    ((2023, 12), 31),   # December
    
    # Leap years
    ((2024, 1), 31),    # January
    ((2024, 2), 29),    # February in leap year
    ((2000, 2), 29),    # February in leap year
    ((2564, 2), 29),    # February in leap year
    ((2024, 3), 31),    # March
    ((2024, 4), 30),    # April
    ((2024, 5), 31),    # May
    ((2024, 6), 30),    # June
    ((2024, 7), 31),    # July
    ((2024, 8), 31),    # August
    ((2024, 9), 30),    # September
    ((2024, 10), 31),   # October
    ((2024, 11), 30),   # November
    ((2024, 12), 31),   # December
]
@pytest.mark.parametrize("inputs, expected", days_in_month_cases)
def test_days_in_month(inputs, expected):
    year, month = inputs
    assert prac3_part1.days_in_month(year, month) == expected
    
if __name__ == "__main__":
    pytest.main(["prac3_part1A_test.py", "-v",  "-p", "no:faulthandler"])
    
    
