# Exam 2 tests - triangle (6 of 20 points)
import pytest
from exam2 import triangle

@pytest.mark.parametrize("height, expected_output", [
    (2, """#
##"""),
    (4, """#
##
# #
####"""),
    (5, """#
##
# #
#  #
#####"""),
    (24, """#
##
# #
#  #
#   #
#    #
#     #
#      #
#       #
#        #
#         #
#          #
#           #
#            #
#             #
#              #
#               #
#                #
#                 #
#                  #
#                   #
#                    #
#                     #
########################"""),
])

def test_triangle(height, expected_output, capsys):
    triangle(height)
    output = capsys.readouterr().out.strip()
    assert output == expected_output

if __name__ == "__main__":
    pytest.main(["triangle_test.py", "-vv", "-p", "no:faulthandler"])
