# Exam 2 tests - Main program (2 of 20 points)

import sys
import subprocess
import pytest

main_cases = [
    (["1", "6"],       "1"),
    (["1", "66"],      "3"),
    (["10", "100"],    "3"),
    (["100", "156"],   "2"),
    (["156", "156"],   "1"),
]

def test_mainguard(capsys):
    command = [sys.executable, "-c", "import exam2"]
    message = "importing exam2 should not print any output or cause an error; make sure your main program is in a main guard"
    try:
        assert subprocess.check_output(command, text=True) == "", message
    except subprocess.CalledProcessError:
        assert False, message

@pytest.mark.parametrize("inputs, expected", main_cases)
def test_mainprogram(inputs, expected):
    command = [sys.executable, "exam2.py", *[str(x) for x in inputs]]
    output = subprocess.check_output(command, text=True).rstrip()
    
    assert output == str(expected)

if __name__ == "__main__":
    pytest.main(["main_test.py", "-v",  "-p", "no:faulthandler"])
    
