# Exam 3 - main program tests (2 points)
import pytest
import subprocess

def run_with_args(filename, *args):
    args = [str(a) for a in args]
    try:
        command = ["python3", filename + ".py", *args]
        return subprocess.check_output(command, text=True).rstrip("\n")
    except:
        command = ["python", filename + ".py", *args]
        return subprocess.check_output(command, text=True).rstrip("\n")

def test_main_guard(capsys):
    import importlib

    if 'exam3' in importlib.sys.modules:
        del importlib.sys.modules['exam3']

    import exam3 

    captured = capsys.readouterr()
    assert captured.out == "", "Importing exam3 produced output; check your main guard."
    assert captured.err == "", "Importing exam3 produced output; check your main guard."

test_cases = [
        (0, 0),
        (100, 3),
        (1000, 39)
]

@pytest.mark.parametrize("arg, expected", test_cases)
def test_main_program_line1(arg, expected):
    output = run_with_args("exam3", arg)
    assert output.strip() == str(expected)

# remove any command line arguments to the test program 
import sys
if len(sys.argv) > 1:
    del sys.argv[1:] 

pytest.main(["main_test.py",  "-vv", "--showlocals", "-p", "no:faulthandler"])



