""" There are four functions below to implement, plus a main program
at the bottom of this file. The main program prints one number, making
use of the sevens and has_seven functions. I recommend implementing things
in the following order:
1. length_order (6 points)
2. sevens (4 points)
3. has_seven (4 points)
4. main program (2 points)
5. swaep (4 points)
"""

def length_order(s1, s2): # 6 points
    """ Return a 2-tuple containing strings s1 and s2, ordered by length, i.e.,
    return (a, b) such that a is the shorter of s1 and 2, and b is the longer.
    If both strings have the same length, return them in lexicographic 
    (i.e., dictionary) order.
    Examples:
        length_order("a", "aa") => ("a", "aa")
        length_order("abc", "de") => ("de", "abc")
        length_order("tortoise", "hare") => ("hare", "tortoise")
        length_order("empty", "") => ("", "empty")
        length_order("abc", "def") => ("abc", "def")
        length_order("cat", "bag") => ("bag", "cat") 
    """


def sevens(n): # 4 points
    """ Return a list of numbers between 0 and n (inclusive) that are divisible
    by 7. Precondition: n is a non-negative integer.
    Examples:
        sevens(1) => [0]
        sevens(100) => [0, 7, 14, 21, 28, 35, 42, 49, 56, 63, 70, 77, 84, 91, 98]
        sevens(21) => [0, 7, 14, 21] (includes 21)
    """


def has_seven(nums): # 4 points
    """ Return the number of items in nums that have 7 as one of their digits.
    Precondition: nums is a list of numbers.
    Examples:
        has_seven([0]) => 0
        has_seven([0, 7]) => 1
        has_seven([7, 77, 777]) => 3
        has_seven(sevens(100)) => 3
    """
    
    
def swaep(string): # 4 points
    """ Return string, but with all instances of 'a' replaced with 'e' and
    all instances of 'e' replaced with 'a'. Does not affect upper case letters.
    Precondition: string is a string
    Examples:
        swaep("swap") => "swep"
        swaep("sweep") => "swaap"
        swaep("swaep") => "sweap"
        swaep("ABBA") => "ABBA" (ignores upper case)
    """


""" Main program: 2 points
The main program takes one positive integer command line argument.
It uses the sevens and has_seven functions find and print how many 
integers between 0 and n (inclusive) are divisble by 7 and also contain
the digit 7. Be sure to put your main program in a main guard.
Examples:
>>> %Run exam3.py 0
0
>>> %Run exam3.py 10 # one of [0, 7] contains the digit 7
1
>>> %Run exam3.py 100 # three multiples of 7 between 0 and 100 contain the digit 7: 7, 70, and 77
3
>>> %Run exam3.py 1000
39

Write your main program below:
"""

