# Exam 2 Tests - Problem 3 (1 of 20 points)
import pytest

import p3

# Test cases: ((a, b, c, d, f), expected_lines)
test_cases = [
    ((3, 5, 6, 4, 1),
     ['    #', '  # #', '  # # #', '# # # #', '# # # #', '# # # # #', 'a b c d f']),
    ((0, 1, 0, 0, 0),
     ['  #', 'a b c d f']),
    ((1, 2, 3, 5, 0),
     ['      #', '      #', '    # #', '  # # #', '# # # #', 'a b c d f']),
    ((0, 0, 0, 0, 0),
     ['a b c d f'])
]

@pytest.mark.parametrize("inputs, expected", test_cases)
@pytest.mark.timeout(3)
def test_plot(inputs, expected):
    result = p3.plot_dist(*inputs)
    output_lines = [line.rstrip() for line in result.rstrip().split('\n')]
    
    assert output_lines == expected
    

if __name__ == "__main__":
    pytest.main(["p3_test.py", "-vv",  "-p", "no:faulthandler"])
