# Exam 2 Tests - Problem 1 (9 of 20 points)
import pytest

import p1

# Test cases for days_in_month: ((year, month), days)
days_in_month_cases = [
    # non-leap years
    ((2023, 1), 31),    # January
    ((2021, 2), 28),    # February (non-leap)
    ((2022, 2), 28),    # February (non-leap)
    ((2025, 2), 28),    # February (non-leap)
    ((2022, 3), 31),    # March
    ((2025, 4), 30),    # April
    ((1901, 5), 31),    # May
    ((2023, 6), 30),    # June
    ((2023, 7), 31),    # July
    ((2023, 8), 31),    # August
    ((2023, 9), 30),    # September
    ((2023, 10), 31),   # October
    ((2023, 11), 30),   # November
    ((2023, 12), 31),   # December
    
    # Leap years
    ((2024, 1), 31),    # January
    ((2024, 2), 29),    # February in leap year
    ((2000, 2), 29),    # February in leap year
    ((2564, 2), 29),    # February in leap year
    ((2024, 3), 31),    # March
    ((2024, 4), 30),    # April
    ((2024, 5), 31),    # May
    ((2024, 6), 30),    # June
    ((2024, 7), 31),    # July
    ((2024, 8), 31),    # August
    ((2024, 9), 30),    # September
    ((2024, 10), 31),   # October
    ((2024, 11), 30),   # November
    ((2024, 12), 31),   # December
]

# Test cases for day_of_year: ((year, month, day), day_of_year)
day_of_year_cases = [
    # Regular year tests - first day of each month
    ((2023, 1, 1), 1),      # January 1 (non-leap year)
    ((2023, 2, 1), 32),     # February 1 (non-leap year)
    ((2023, 3, 1), 60),     # March 1 (non-leap year)
    ((2023, 4, 1), 91),     # April 1 (non-leap year)
    ((2023, 5, 1), 121),    # May 1 (non-leap year)
    ((2023, 6, 1), 152),    # June 1 (non-leap year)
    ((2023, 7, 1), 182),    # July 1 (non-leap year)
    ((2023, 8, 1), 213),    # August 1 (non-leap year)
    ((2023, 9, 1), 244),    # September 1 (non-leap year)
    ((2023, 10, 1), 274),   # October 1 (non-leap year)
    ((2023, 11, 1), 305),   # November 1 (non-leap year)
    ((2023, 12, 1), 335),   # December 1 (non-leap year)
    
    # Leap year tests - first day of each month
    ((2024, 1, 1), 1),      # January 1 (leap year)
    ((2024, 2, 1), 32),     # February 1 (leap year)
    ((2024, 3, 1), 61),     # March 1 (leap year)
    ((2024, 4, 1), 92),     # April 1 (leap year)
    ((2024, 5, 1), 122),    # May 1 (leap year)
    ((2024, 6, 1), 153),    # June 1 (leap year)
    ((2024, 7, 1), 183),    # July 1 (leap year)
    ((2024, 8, 1), 214),    # August 1 (leap year)
    ((2024, 9, 1), 245),    # September 1 (leap year)
    ((2024, 10, 1), 275),   # October 1 (leap year)
    ((2024, 11, 1), 306),   # November 1 (leap year)
    ((2024, 12, 1), 336),   # December 1 (leap year)
    
    # Special dates in non-leap year
    ((2023, 2, 28), 59),    # February 28 (non-leap year)
    ((2023, 3, 1), 60),     # March 1 (non-leap year)
    ((2023, 12, 31), 365),  # December 31 (non-leap year)
    
    # Special dates in leap year
    ((2024, 2, 28), 59),    # February 28 (leap year)
    ((2024, 2, 29), 60),    # February 29 (leap day)
    ((2024, 3, 1), 61),     # March 1 (leap year)
    ((2024, 12, 31), 366),  # December 31 (leap year)
    
    # Additional test cases for various dates
    ((2023, 4, 15), 105),   # April 15 (non-leap year)
    ((2024, 4, 15), 106),   # April 15 (leap year)
    ((2023, 7, 4), 185),    # July 4 (non-leap year)
    ((2024, 7, 4), 186),    # July 4 (leap year)
]


@pytest.mark.parametrize("inputs, expected", days_in_month_cases)
def test_days_in_month(inputs, expected):
    year, month = inputs
    assert p1.days_in_month(year, month) == expected
    

@pytest.mark.parametrize("inputs, expected", day_of_year_cases)
def test_dayof_year(inputs, expected):
    year, month, day = inputs
    assert p1.day_of_year(year, month, day) == expected

if __name__ == "__main__":
    pytest.main(["p1_test.py", "-vv",  "-p", "no:faulthandler"])
