# Final exam - that_stacks tests
import pytest

import final


that_stacks_cases = [
    ([(4, 4)], True),
    ([(4, 4), (3, 3), (2, 2)], True),
    ([(4, 2), (3, 2), (1, 2)], True),
    ([(4, 2), (2, 3), (1, 3)], True),
    ([(4, 2), (5, 5)], False),
    ([(2, 6), (2, 5), (5, 3)], False),
    ([(5, 3), (4, 4)], False),
    ([(3, 6), (3, 5), (2, 4)], True),
    ([(2, 2), (2, 2), (2, 2)], True),
    ([(10, 5), (5, 10), (4, 6)], True),
    ([(10, 10), (9, 9), (8, 8), (7, 7)], True),
    ([(5, 3), (3, 5)], True),
    ([(6, 4), (4, 6), (5, 5)], False),
    ([(10, 5), (9, 4), (8, 3), (7, 2)], True),
    ([(1, 1), (1, 1)], True),
    ([(100, 50), (99, 49)], True),
    ([(3, 4), (4, 3)], True),
    ([(5, 5), (5, 4), (4, 5)], True),
    ([(10, 8), (8, 10)], True),
    ([(7, 6), (6, 7), (5, 5)], True),
]


@pytest.mark.parametrize("papers, expected", that_stacks_cases)
def test_that_stacks(papers, expected):
    assert final.that_stacks(papers) == expected


if __name__ == "__main__":
    pytest.main(["that_stacks_test.py", "-vv", "-p", "no:faulthandler"])
