# Final exam - runner_up tests
import pytest

import final


rainier_cases = [
    ([1], [1]),
    ([1, 2, 2, 3], [1, 2, 2, 3]),
    ([3, 2, 1], [3]),
    ([1, 3, 2, 2, 4, 5, 1, 2], [2, 2, 4, 5]),
    ([1, 1, 1, 0, 0, 1], [1, 1, 1]),
    ([3, 4, 4, 2, 3, 3, 3], [2, 3, 3, 3]),
    ([10, 9, 9, 8, 8, 8, 7], [8, 8, 8]),
    ([5, 4, 6, 6, 6, 2, 3, 4], [4, 6, 6, 6]),
    ([1, 1], [1, 1]),
    ([7, 7, 7, 7, 1], [7, 7, 7, 7]),
    ([1, 2, 3, 4, 5], [1, 2, 3, 4, 5]),
    ([5, 4, 3, 2, 1], [5]),
    ([1, 2, 1, 2, 1, 2, 3, 4], [1, 2, 3, 4]),
    ([0, 0, 0, 0], [0, 0, 0, 0]),
    ([1, 2, 3, 2, 3, 4, 5, 6], [2, 3, 4, 5, 6]),
    ([-1, 0, 1, 2], [-1, 0, 1, 2]),
    ([10, 5, 5, 5, 5, 3, 4, 5, 6, 7], [3, 4, 5, 6, 7]),
    ([2, 2, 2, 1, 3, 4, 4, 4], [1, 3, 4, 4, 4]),
    ([1, 1, 1, 1, 1], [1, 1, 1, 1, 1]),
    ([5, 4, 3, 3, 4, 5, 6, 7, 8], [3, 3, 4, 5, 6, 7, 8]),
]


@pytest.mark.parametrize("lst, expected", rainier_cases)
def test_rainier(lst, expected):
    assert final.rainier(lst) == expected


if __name__ == "__main__":
    pytest.main(["rainier_test.py", "-vv", "-p", "no:faulthandler"])
