# Final exam - peter tests
import pytest

import final

test_cases = [
    (("hello world", "o", 3), "hellooo wooorld"),
    (("banana boat", "an", 2), "baannaannaa boaat"),
    (("Babbage", "ag", 0), "Bbbe"),
    (("", "a", 1), ""),
    (("hello", "", 3), "hello"),
    (("hello world", "l", 0), "heo word"),
    (("test", "test", 0), ""),
    (("hello", "l", 1), "hello"),
    (("a", "a", 3), "aaa"),
    (("aaa", "a", 2), "aaaaaa"),
    (("hello", "l", 4), "hellllllllo"),
    (("hello world", "lo", 2), "helllloo woorlld"),
    (("programming", "rgm", 3), "prrrogggrrrammmmmminggg"),
    (("abcabc", "ac", 2), "aabccaabcc"),
    (("Hello", "H", 2), "HHello"),
    (("AaAa", "A", 3), "AAAaAAAa"),
    (("hello", "xyz", 5), "hello"),
    (("hello, world!", ",!", 2), "hello,, world!!"),
    (("test123", "1", 3), "test11123"),
    (("a-b-c", "-", 4), "a----b----c"),
]

@pytest.mark.parametrize("inputs, expected", test_cases)
def test_peter(inputs, expected):
    assert final.peter(*inputs) == expected

if __name__ == "__main__":
    pytest.main(["peter_test.py", "-vv",  "-p", "no:faulthandler"])


