# Final exam - Main program tests

import sys
import subprocess
import pytest

main_cases = [
    (["o", "3", "hello"], "hellooo"),
    (["o", "3", "hello", "world"], "hellooo wooorld"),
    (["wu", "4", "aw", "cute", "cat"], "awwww cuuuute cat"),
    (["a", "1", "banana"], "banana"),
    (["l", "0", "hello"], "heo"),
    (["", "2", "test"], "test"),
    (["e", "2", "hello"], "heello"),
]

def test_mainguard():
    command = [sys.executable, "-c", "import final"]
    message = "importing final should not print any output or cause an error; make sure your main program is in a main guard"
    try:
        assert subprocess.check_output(command, text=True) == "", message
    except subprocess.CalledProcessError:
        assert False, message

@pytest.mark.parametrize("inputs, expected", main_cases)
def test_mainprogram(inputs, expected):
    command = [sys.executable, "final.py", *inputs]
    output = subprocess.check_output(command, text=True).rstrip()
    
    assert output == expected

if __name__ == "__main__":
    pytest.main(["main_test.py", "-v", "-p", "no:faulthandler"])
