# Final exam - lengthy_words tests
import pytest

import final


lengthy_words_cases = [
    ("", {}),
    ("a", {1: 1}),
    ("a bc def", {1: 1, 2: 1, 3: 1}),
    ("two banana bot", {3: 2, 6: 1}),
    ("one two three four five", {3: 2, 5: 1, 4: 2}),
    ("hi hi hi", {2: 3}),
    ("  spaced   words ", {6: 1, 5: 1}),
    ("I am learning", {1: 1, 2: 1, 8: 1}),
    ("the quick brown fox", {3: 2, 5: 2}),
    ("test case", {4: 2}),
    ("hello world", {5: 2}),
    ("programming", {11: 1}),
    ("a b c d e", {1: 5}),
    ("Mississippi", {11: 1}),
    ("x xx xxx xxxx", {1: 1, 2: 1, 3: 1, 4: 1}),
    ("python java go rust", {6: 1, 4: 2, 2: 1}),
    ("the the the", {3: 3}),
    ("supercalifragilisticexpialidocious", {34: 1}),
    ("cat dog elephant bird", {3: 2, 8: 1, 4: 1}),
    ("code is awesome", {4: 1, 2: 1, 7: 1}),
]


@pytest.mark.parametrize("text, expected", lengthy_words_cases)
def test_lengthy_words(text, expected):
    assert final.lengthy_words(text) == expected


if __name__ == "__main__":
    pytest.main(["lengthy_words_test.py", "-vv", "-p", "no:faulthandler"])
