# Exam 3 tests - file_reverse (8 of 20 points)

import pytest
import pathlib
from exam3 import file_reverse

test_cases = [
    {"input": """\
line 1
line 2
line 3
""",
     "expected": """\
line 3
line 2
line 1
"""},
    {"input": """\
only one line
""",
     "expected": """\
only one line
"""},
    {"input": "",
     "expected": ""},
    {"input": """\
First line

Third line (second was blank)
Fourth line with numbers 123
""",
     "expected": """\
Fourth line with numbers 123
Third line (second was blank)

First line
"""},
    {"input": """\
Line 1
Line 2
Line 3
Line 4
Line 5
Line 6
Line 7
Line 8
Line 9
Line 10
""",
     "expected": """\
Line 10
Line 9
Line 8
Line 7
Line 6
Line 5
Line 4
Line 3
Line 2
Line 1
"""},
    {"input": """\
a
b

""",
     "expected": """\

b
a
"""},
    {"input": """\

Alpha
Beta
Gamma
Delta
Epsilon
""",
     "expected": """\
Epsilon
Delta
Gamma
Beta
Alpha

"""},
    {"input": """\
1
2
3
4
5
6
7
8
9
10
11
12
""",
     "expected": """\
12
11
10
9
8
7
6
5
4
3
2
1
"""},
]

test_dir = pathlib.Path("./file_reverse_tests")

@pytest.fixture(scope="module")
def input_files():
    """
    Creates files for all test cases and returns a mapping
    of test case index to file path. Uses module scope for reuse.
    """
    test_dir.mkdir(exist_ok=True)
    
    file_mapping = {}
    for i in range(len(test_cases)):
        input_file = test_dir / f"input{i}.txt"
        input_file.write_text(test_cases[i]["input"])
        file_mapping[i] = input_file
    
    return file_mapping


@pytest.mark.parametrize("test_index", range(8))
def test_file_reverse(input_files, test_index):
    input_file = input_files[test_index]
    output_file = test_dir / f"output{test_index}.txt"
    
    file_reverse(str(input_file), str(output_file))
    
    result = output_file.read_text()
    expected = test_cases[test_index]["expected"]
    assert result == expected

if __name__ == "__main__":
    pytest.main(["file_reverse_test.py", "-vv", "-p", "no:faulthandler"])
