# Exam 3 tests - brackets_match (4 of 20 points)

import pytest
from exam3 import brackets_match

@pytest.mark.parametrize("s, expected", [
    ("[]", True),
    ("[[]]", True),
    ("[[]", False),
    ("[]]", False),
    ("abc[def]ghi", True),
    ("a[b[c]d]e", True),
    ("", True),
    ("[", False),
    ("]", False),
    ("[[[[]]]]", True),
    ("[[[[]]]", False),
    ("text without brackets", True),
    ("[a][b][c]", True),
    ("[a[b]c[d]e]", True),
    ("[][]", True),
    ("[[][]]", True),
    ("x[y]z[w]", True),
    ("[hello [world]]", True),
    ("][", False),
    ("]]][[[", False),
    ("]][[", False),
    ("][[]][", False),
    ("][]]][[[[]", False),
    ("abc]def[ghi", False),
])
def test_brackets_match(s, expected):
    assert brackets_match(s) == expected

if __name__ == "__main__":
    pytest.main(["brackets_match_test.py", "-vv", "-p", "no:faulthandler"])
