# Exam 2 tests - Main program (2 of 20 points)

import pytest
from exam2 import change

# Test only total cents returned
@pytest.mark.parametrize("args, expected_total", [
    # owe, $, q, d, n, p
    ((100, 0, 5, 0, 0, 0), 25),
    ((100, 1, 0, 0, 0, 0), 0),
    ((189, 2, 0, 0, 0, 0), 11),
    ((132, 2, 0, 0, 0, 1), 69),
    ((99, 0, 4, 1, 0, 4), 15),
    ((200, 1, 3, 5, 4, 11), 56),
])
def test_change_total(args, expected_total):
    q, d, n, p = change(*args)
    total = 25*q + 10*d + 5*n + p
    assert total == expected_total


@pytest.mark.parametrize("args, expected", [
    # owe, $, q, d, n, p
    ((100, 0, 5, 0, 0, 0), (1, 0, 0, 0)),
    ((100, 1, 0, 0, 0, 0), (0, 0, 0, 0)),
    ((189, 2, 0, 0, 0, 0), (0, 1, 0, 1)),
    ((132, 2, 0, 0, 0, 1), (2, 1, 1, 4)),
    ((99,  0, 4, 1, 0, 4), (0, 1, 1, 0)),
    ((200, 1, 3, 5, 4, 11), (2, 0, 1, 1)),
])
def test_exact_change(args, expected):
    assert change(*args) == expected


if __name__ == "__main__":
    pytest.main(["change_test.py", "-vv", "-p", "no:faulthandler"])
